/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.httpclient.async;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.httpclient.async.AbstractAsyncHttpClientTracker;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;

public class AsyncHttpClientTracker
extends AbstractAsyncHttpClientTracker {
    public AsyncHttpClientTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
        this.httpUrl = this.getRequestUrl(args[0]);
        this.method = this.getHttpMethod(args[0]);
    }

    @Override
    public void quit(int opcode, Object returnValue) {
        super.quit(opcode, returnValue);
        if (returnValue == null) {
            return;
        }
        try {
            Method m = returnValue.getClass().getDeclaredMethod("toCompletableFuture", new Class[0]);
            CompletableFuture future = (CompletableFuture)m.invoke(returnValue, new Object[0]);
            this.setCallbackObj(future);
        }
        catch (ClassCastException cce) {
            JavaAgent.logger.warn("NettyAsyncHttp unexpected future reference. {}", cce.getMessage());
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("NettyAsyncHttp unable to set callback obj. {}", th.getMessage());
        }
    }

    @Override
    public String getRequestUrl(Object requestObject) {
        try {
            Method method = requestObject.getClass().getMethod("getUrl", new Class[0]);
            return method.invoke(requestObject, new Object[0]).toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public String getHttpMethod(Object requestObject) {
        try {
            Method method = requestObject.getClass().getMethod("getMethod", new Class[0]);
            return method.invoke(requestObject, new Object[0]).toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public int getStatusCode(Object respObj) {
        try {
            Method m = respObj.getClass().getMethod("getStatusCode", new Class[0]);
            return (Integer)m.invoke(respObj, new Object[0]);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    @Override
    public void setDTHeaderInRequest(Object requestObject) {
        AsyncHttpClientTracker.setDTHeader(requestObject);
    }

    @Override
    public String getDTHeaderFromResponse(Object respObj) {
        try {
            Method m = respObj.getClass().getMethod("getHeader", CharSequence.class);
            return (String)m.invoke(respObj, "X-Site24x7-DT-Data");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void setDTHeader(Object requestBuilderObj) {
        try {
            SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
            if (seqSpace.getConfig() != null && seqSpace.getConfig().isDistributedTracingEnabled()) {
                Method m = requestBuilderObj.getClass().getMethod("setHeader", CharSequence.class, String.class);
                m.invoke(requestBuilderObj, "X-Site24x7-Id", JavaAgent.getInstance().agentConfig.getDistributedTracingId());
                JavaAgent.logger.trace("Netty Async, DT Header successfully added");
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Unable to set DT header to Netty Async, {}", th.getMessage());
        }
    }
}

