/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.httpclient.async;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.HttpClientPointcutProperties;
import com.manageengine.apminsight.agent.trackers.httpclient.AbstractHttpClientTracker;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class SpringReactiveExchangeFunctionTracker
extends AbstractHttpClientTracker {
    public SpringReactiveExchangeFunctionTracker(HttpClientPointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
        this.httpUrl = this.getRequestUrl(args[0]);
        this.method = this.getHttpMethod(args[0]);
    }

    @Override
    public String getRequestUrl(Object requestObject) {
        try {
            Field f = requestObject.getClass().getDeclaredField("url");
            f.setAccessible(true);
            return f.get(requestObject).toString();
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "SpringReactiveWebClient Request - Unable to get URL. " + th.getMessage());
            return this.httpUrl;
        }
    }

    @Override
    public String getHttpMethod(Object requestObject) {
        try {
            Field f = requestObject.getClass().getDeclaredField("method");
            f.setAccessible(true);
            return f.get(requestObject).toString();
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "SpringReactiveWebClient Request - Unable to get httpMethod for  " + this.httpUrl + ":" + th.getMessage());
            return this.method;
        }
    }

    @Override
    public int getStatusCode(Object respObj) {
        return this.statusCode;
    }

    public void setStatusCode(int sc) {
        this.statusCode = sc;
    }

    @Override
    public String getDTHeaderFromResponse(Object reqSupplierinRespObj) {
        try {
            Field f = reqSupplierinRespObj.getClass().getDeclaredField("headers");
            f.setAccessible(true);
            Object headersObj = f.get(reqSupplierinRespObj);
            Method m = headersObj.getClass().getMethod("getFirst", Object.class);
            m.setAccessible(true);
            String dtHeaderValue = m.invoke(headersObj, "X-Site24x7-DT-Data").toString();
            if (!StringUtils.isEmptyString(dtHeaderValue)) {
                this.dtData = dtHeaderValue;
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[ReactiveWebClient] Exception while getting dtdata from response object. " + th.getMessage());
        }
        return this.dtData;
    }

    @Override
    public void setDTHeaderInRequest(Object requestObject) {
    }
}

