/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.httpclient.async.apache.nio;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ApdexMetric;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.HTTPMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.sequence.SequenceType;
import com.manageengine.apminsight.agent.tracing.AsyncTracerService;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.VoidTracker;
import com.manageengine.apminsight.agent.trackers.httpclient.HttpClientTrackerUtil;
import com.manageengine.apminsight.agent.util.SequenceURINormalizer;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.json.simple.JSONObject;
import com.manageengine.org.json.simple.JSONValue;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ApacheNioHttpRequestTracker
extends CallerAsyncRootTracker {
    private String httpUrl;
    private String method;
    private String dtData;
    private int statusCode;
    private boolean isDTSetInRequest;
    private boolean isClientCall;
    protected Object conn;
    protected Object request;
    protected Object response;

    public ApacheNioHttpRequestTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args, boolean isClientCall) {
        super(pointcutProperties, thiz, args);
        this.isClientCall = isClientCall;
        this.isLeafTracker = isClientCall;
        this.conn = args[0];
        try {
            Method m = this.conn.getClass().getMethod("getHttpRequest", new Class[0]);
            m.setAccessible(true);
            this.request = m.invoke(this.conn, new Object[0]);
            if (this.request != null) {
                this.fetchRequestInfo(this.request);
            }
        }
        catch (Throwable th) {
            this.httpUrl = null;
            JavaAgent.logger.warn("[ApacheNioHttpServerTracker] Unable to construct the http url. Exception: " + th.getMessage(), th);
        }
    }

    @Override
    protected String assignSequenceName() {
        if (this.httpUrl == null) {
            this.seqName = "unknown";
        } else {
            this.unnormalizedSeqName = this.httpUrl;
            this.seqName = SequenceURINormalizer.normalizeURI(this.unnormalizedSeqName);
        }
        this.hasMetric = true;
        return this.seqName;
    }

    @Override
    public SequenceType getSequenceType() {
        return this.isClientCall ? SequenceType.BACKGROUND : SequenceType.WEB_HTTP;
    }

    private void fetchRequestInfo(Object request) throws Exception {
        Method m = request.getClass().getMethod("getRequestLine", new Class[0]);
        Object requestLine = m.invoke(request, new Object[0]);
        this.seqName = this.httpUrl = this.getRequestUrl(requestLine);
        this.method = this.getHttpMethod(requestLine);
        this.isDTSetInRequest = this.isClientCall ? this.setDTHeaderInRequest(request) : this.getDTHeaderFromRequest(request);
    }

    @Override
    public void quit(int opcode, Object returnValue) {
        super.quit(opcode, returnValue);
        if (this.request == null) {
            try {
                Method m = this.conn.getClass().getMethod("getHttpRequest", new Class[0]);
                m.setAccessible(true);
                this.request = m.invoke(this.conn, new Object[0]);
                if (this.request != null) {
                    this.fetchRequestInfo(this.request);
                }
            }
            catch (Throwable th) {
                this.httpUrl = null;
                JavaAgent.logger.warn("[ApacheNioHttpServerTracker] Unable to construct the http url. Exception: " + th.getMessage(), th);
            }
        }
        if (this.response == null) {
            this.setCallbackObj(this.conn);
            this.conn = null;
        } else {
            this.statusCode = this.getStatusCode(this.response);
        }
    }

    @Override
    protected void quit() {
        super.quit();
        if (this.response != null) {
            this.response = null;
        }
    }

    public String getRequestUrl(Object requestObject) {
        try {
            Method getURI = requestObject.getClass().getMethod("getUri", new Class[0]);
            getURI.setAccessible(true);
            return getURI.invoke(requestObject, new Object[0]) + "";
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[ApacheNioHttpRequest] Unable to get request URL. " + th.getMessage());
            return this.httpUrl;
        }
    }

    public String getHttpMethod(Object requestObject) {
        try {
            Class<?> clz = requestObject.getClass();
            Method m = clz.getMethod("getMethod", new Class[0]);
            m.setAccessible(true);
            return m.invoke(requestObject, new Object[0]).toString();
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[ApacheNioHttpRequest] Unable to get request type. " + th);
            return this.method;
        }
    }

    public int getStatusCode(Object respObj) {
        try {
            Method m = respObj.getClass().getMethod("getStatusLine", new Class[0]);
            Object statusline = m.invoke(respObj, new Object[0]);
            m = statusline.getClass().getMethod("getStatusCode", new Class[0]);
            return (Integer)m.invoke(statusline, new Object[0]);
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[ApacheNioHttpServer] Unable to get status code. " + th);
            return this.statusCode;
        }
    }

    public void setResponseObject(Object response) {
        this.response = response;
        if (this.isDTSetInRequest) {
            if (this.isClientCall) {
                this.getDTHeaderFromResponse(response);
            } else {
                this.setDTHeaderInResponse(response);
            }
        }
    }

    public boolean setDTHeaderInRequest(Object requestObject) {
        boolean isHeaderSet = false;
        try {
            SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
            if (seqSpace.getConfig() != null && seqSpace.getConfig().isDistributedTracingEnabled()) {
                Class<?> reqClass = requestObject.getClass();
                Method m = reqClass.getMethod("setHeader", String.class, String.class);
                m.invoke(requestObject, "X-Site24x7-Id", JavaAgent.getInstance().agentConfig.getDistributedTracingId());
                isHeaderSet = true;
                JavaAgent.logger.trace("[ApacheNioHttpClient] Outgoing request id added to header " + this.httpUrl);
            }
        }
        catch (Exception e) {
            JavaAgent.logger.log(Level.WARN, "Unable to set DT header in request. Exception: " + e.getMessage());
        }
        return isHeaderSet;
    }

    public String getDTHeaderFromResponse(Object respObj) {
        try {
            Class<?> respClass = respObj.getClass();
            Method m = respClass.getMethod("getFirstHeader", String.class);
            m.setAccessible(true);
            Object header = m.invoke(respObj, "X-Site24x7-DT-Data");
            if (header != null) {
                m = header.getClass().getMethod("getValue", new Class[0]);
                this.dtData = (String)m.invoke(header, new Object[0]);
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[ApacheNioHttpClient] Exception while reading response header. " + th.getMessage());
        }
        return this.dtData;
    }

    private boolean getDTHeaderFromRequest(Object request) {
        try {
            Method m = request.getClass().getMethod("getFirstHeader", String.class);
            m.setAccessible(true);
            String id = (String)m.invoke(request, "X-Site24x7-Id");
            return JavaAgent.getInstance().agentConfig.getDistributedTracingId().equals(id);
        }
        catch (Throwable th) {
            return false;
        }
    }

    private void setDTHeaderInResponse(Object response) {
        if (response == null) {
            return;
        }
        try {
            Method m = response.getClass().getMethod("setHeader", String.class, String.class);
            m.setAccessible(true);
            HashMap<String, Object> dtData = new HashMap<String, Object>();
            dtData.put("s_time", this.startTime);
            dtData.put("t_name", this.getSequenceNameSpace());
            dtData.put("instance_id", ContextInfoManager.getInstance().getDefaultContextInfo().getInstanceID());
            m.invoke(response, "X-Site24x7-DT-Data", JSONObject.toJSONString(dtData));
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[ApacheNioHttpServer]Unable to set dt header in response, Exception: " + th.getMessage());
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        if (this.isClientCall) {
            super.generateMetric(seqHeader, childDuration, metricData);
            ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), HttpClientTrackerUtil.extractServerAddress(this.httpUrl), HttpClientTrackerUtil.extractInstanceIdFromDtData(this.dtData), this.duration - childDuration, this.isErroneous());
        } else {
            ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.duration - childDuration, this.isErroneous());
            if (this.statusCode >= 400) {
                ((HTTPMetric)metricData).recordHttpRespCode(this.statusCode);
                ((ApdexMetric)metricData).recordErroneousData(this.getDuration());
            } else if (this.isErroneous()) {
                ((ApdexMetric)metricData).recordErroneousData(this.getDuration());
            } else {
                ((ApdexMetric)metricData).recordData(this.getDuration(), seqHeader.getApplicationConfig().getWebSeqConfig().getApdexThreshold());
            }
        }
        return this.hasMetric;
    }

    @Override
    public Map<String, Object> getContextualMetrics() {
        LinkedHashMap<String, Object> xtraMetrics = new LinkedHashMap<String, Object>(4, 1.0f);
        xtraMetrics.put("http_method_name", this.method);
        if (this.statusCode != 0) {
            xtraMetrics.put("httpcode", this.statusCode);
        }
        return xtraMetrics;
    }

    @Override
    public Map<String, Object> getMoreData(Map<String, Object> moreData) {
        if (this.dtData != null) {
            Map data = (Map)JSONValue.parse(this.dtData);
            moreData.put("dtdata", data);
        }
        return moreData;
    }

    @Override
    public String getTrackerSignature() {
        if (!this.isClientCall) {
            return super.getTrackerSignature();
        }
        if (this.httpUrl == null) {
            return super.getTrackerSignature();
        }
        StringBuffer signature = new StringBuffer(this.getTrackerSignaturePrefix());
        if (this.method != null) {
            signature.append(this.method.toUpperCase());
            signature.append(" - ");
        }
        if (this.statusCode > 0) {
            signature.append(this.statusCode);
            signature.append(" - ");
        }
        signature.append(this.httpUrl);
        if (this.isErroneous()) {
            signature.append(" Error: " + this.error.getClass().getSimpleName());
        }
        return signature.toString();
    }

    @Override
    public String getNormalizedSignature() {
        if (!this.isClientCall) {
            return super.getTrackerSignature();
        }
        if (this.httpUrl == null) {
            return super.getTrackerSignature();
        }
        StringBuffer signature = new StringBuffer(this.getTrackerSignaturePrefix());
        if (this.method != null) {
            signature.append(this.method.toUpperCase());
            signature.append(" - ");
        }
        signature.append(this.httpUrl);
        return signature.toString();
    }

    public static class ApacheNioHttpServerResponseTracker
    extends DefaultTracker
    implements VoidTracker {
        private ApacheNioHttpRequestTracker requestTracker;

        public ApacheNioHttpServerResponseTracker(PointcutProperties pointcut, Object thiz, Object[] args) {
            super(pointcut, thiz, args);
            this.requestTracker = (ApacheNioHttpRequestTracker)AsyncTracerService.getInstance().evictTracker(args[0].hashCode());
            if (this.requestTracker != null) {
                this.requestTracker.setResponseObject(this.getResponseObject(args[0]));
            }
        }

        private Object getResponseObject(Object conn) {
            try {
                Method m = conn.getClass().getMethod("getHttpResponse", new Class[0]);
                m.setAccessible(true);
                return m.invoke(conn, new Object[0]);
            }
            catch (Throwable th) {
                return null;
            }
        }

        @Override
        public void quit(int opcode, Object returnValue) {
            if (this.requestTracker != null) {
                this.requestTracker.markCompleted(returnValue);
            }
        }

        @Override
        public void quit(Throwable th) {
            if (this.requestTracker != null) {
                this.requestTracker.markFailed(th);
            }
        }
    }
}

