/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.messaging;

import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.external.IExternalTracker;
import com.manageengine.apminsight.agent.util.InetAddressUtil;

public class MessagingTracker
extends DefaultTracker
implements IExternalTracker {
    private String serverAddress;
    private Object clientObj;

    public MessagingTracker(String serverInfo, PointcutProperties pointcutProperties, Object clientObj, Object[] args) {
        super(pointcutProperties, clientObj, args);
        this.serverAddress = serverInfo;
        this.clientObj = clientObj;
        this.isLeafTracker = true;
    }

    @Override
    public String getTrackerSignature() {
        StringBuilder signature = new StringBuilder(this.pointcutProperties.getComponent().toString());
        signature.append(this.serverAddress != null ? " - " + (this.serverAddress.contains("/") ? this.serverAddress.split("/")[1] : this.serverAddress) : "").append(" - " + this.pointcutProperties.getInterceptedMethodName().toUpperCase()).append(this.isErroneous() ? " - Error: " + this.error.getClass().getSimpleName() : "");
        return signature.toString();
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        this.serverAddress = InetAddressUtil.standardizeServerAddress(this.serverAddress);
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.serverAddress, this.duration - childDuration, this.isErroneous());
        return true;
    }

    @Override
    protected void quit() {
        super.quit();
        this.clientObj = null;
    }

    public Object getClientObj() {
        return this.clientObj;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverInfo) {
        this.serverAddress = serverInfo;
    }
}

