/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.micronaut;

import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.trackers.http.ServerHttpRequest;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MicronautHttpRequest
implements ServerHttpRequest {
    private Object request;

    public MicronautHttpRequest(Object request) {
        this.request = request;
    }

    @Override
    public String getRequestURL() throws Exception {
        Object channelHandlerContext = this.request.getClass().getMethod("getChannelHandlerContext", new Class[0]).invoke(this.request, new Object[0]);
        Method handlerMethod = channelHandlerContext.getClass().getMethod("handler", new Class[0]);
        handlerMethod.setAccessible(true);
        Object handler = handlerMethod.invoke(channelHandlerContext, new Object[0]);
        Field embeddedServerField = handler.getClass().getDeclaredField("embeddedServer");
        embeddedServerField.setAccessible(true);
        Object embeddedServer = embeddedServerField.get(handler);
        Object embeddedServerUrl = embeddedServer.getClass().getMethod("getURL", new Class[0]).invoke(embeddedServer, new Object[0]);
        return embeddedServerUrl.toString() + this.getRequestURI();
    }

    @Override
    public String getRequestURI() throws Exception {
        return (String)this.request.getClass().getMethod("getPath", new Class[0]).invoke(this.request, new Object[0]);
    }

    @Override
    public String getMethod() throws Exception {
        return (String)this.request.getClass().getMethod("getMethodName", new Class[0]).invoke(this.request, new Object[0]);
    }

    @Override
    public String getQueryString() throws Exception {
        Object uri = this.request.getClass().getMethod("getUri", new Class[0]).invoke(this.request, new Object[0]);
        return (String)uri.getClass().getMethod("getQuery", new Class[0]).invoke(uri, new Object[0]);
    }

    @Override
    public Map<String, String[]> getParameterMap() throws Exception {
        Object params = this.request.getClass().getMethod("getParameters", new Class[0]).invoke(this.request, new Object[0]);
        Object paramMap = params.getClass().getMethod("asMap", new Class[0]).invoke(params, new Object[0]);
        Set paramMapEntrySet = (Set)paramMap.getClass().getMethod("entrySet", new Class[0]).invoke(paramMap, new Object[0]);
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        for (Map.Entry entry : paramMapEntrySet) {
            String key = (String)entry.getKey();
            String[] values = ((List)entry.getValue()).toArray(new String[1]);
            parameterMap.put(key, values);
        }
        return parameterMap;
    }

    @Override
    public String getHeader(String name) throws Exception {
        Object headers = this.getAllHeaders();
        return (String)headers.getClass().getMethod("get", CharSequence.class).invoke(headers, name);
    }

    @Override
    public List<String> getHeaderNames() throws Exception {
        Object headers = this.getAllHeaders();
        Object headerAsMap = headers.getClass().getMethod("asMap", new Class[0]).invoke(headers, new Object[0]);
        Object headerNamesSet = headerAsMap.getClass().getMethod("keySet", new Class[0]).invoke(headerAsMap, new Object[0]);
        Method iteratorMethod = headerNamesSet.getClass().getMethod("iterator", new Class[0]);
        iteratorMethod.setAccessible(true);
        Iterator iterator = (Iterator)iteratorMethod.invoke(headerNamesSet, new Object[0]);
        ArrayList<String> headerNames = new ArrayList<String>();
        while (iterator.hasNext()) {
            headerNames.add((String)iterator.next());
        }
        return headerNames;
    }

    @Override
    public long getContentLength() throws Exception {
        return (Long)this.request.getClass().getMethod("getContentLength", new Class[0]).invoke(this.request, new Object[0]);
    }

    @Override
    public void setCharacterEncoding(String charset) throws Exception {
    }

    @Override
    public String getContextPath() throws Exception {
        return ContextInfoManager.getInstance().getDefaultContextInfo().getContextName();
    }

    private Object getAllHeaders() throws Exception {
        return this.request.getClass().getMethod("getHeaders", new Class[0]).invoke(this.request, new Object[0]);
    }
}

