/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.mongodb;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.metrics.MetricName;
import com.manageengine.apminsight.agent.metrics.MetricType;
import com.manageengine.apminsight.agent.metrics.ResponseTimeMetric;
import com.manageengine.apminsight.agent.metrics.store.MetricStore;
import com.manageengine.apminsight.agent.metrics.store.MetricStoreController;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.db.AbstractDBTracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;

public class MongoDB4xTracker
extends AbstractDBTracker {
    private Object dcObj;
    private String operation;
    private String dbName;
    private String collectionName;
    private String fullName;
    private String criteria;

    public MongoDB4xTracker(PointcutProperties pointcut, Object thiz, String args, String methodName) {
        super(pointcut, thiz, null);
        this.isLeafTracker = true;
        this.dcObj = thiz;
        this.operation = methodName;
        this.criteria = args;
    }

    @Override
    protected void quit() {
        super.quit();
        this.getQueryInfo();
        this.dcObj = null;
    }

    private void getQueryInfo() {
        try {
            Method method = this.dcObj.getClass().getMethod("getNamespace", new Class[0]);
            method.setAccessible(true);
            Object temp = method.invoke(this.dcObj, new Object[0]);
            this.fullName = temp.toString();
            String[] DBdotCollectionName = this.fullName.split("\\.");
            this.dbName = DBdotCollectionName[0];
            this.collectionName = DBdotCollectionName[1];
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[MongoDB] Error occurred while capturing additional info. Exception:" + th.getMessage());
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.duration - childDuration, this.isErroneous());
        String contextName = seqHeader.getContextName();
        String seqNameSpace = seqHeader.getRootTracker().getSequenceNameSpace();
        MetricStore metricStore = MetricStoreController.getMetricStore();
        String metricName = "db/all/all/dummy-db";
        ResponseTimeMetric metric = (ResponseTimeMetric)metricStore.getMetric(new MetricName(contextName, "", metricName){

            @Override
            public String getNameSpace() {
                return this.getContextName();
            }
        }, MetricType.RESPONSETIME, false).getMetricData();
        metric.setContextName(contextName);
        if (this.isErroneous()) {
            metric.recordErroneousData(this.duration);
        } else {
            metric.recordData(this.duration);
        }
        try {
            String metricName1 = "";
            metricName = "db/" + this.operation.toLowerCase(Locale.ENGLISH) + "/" + "all" + "/" + "dummy-db";
            metricName1 = "db/" + this.operation.toUpperCase(Locale.ENGLISH) + "/" + this.collectionName + "/" + "dummy-db";
            metric = (ResponseTimeMetric)metricStore.getMetric(new MetricName(contextName, "", metricName){

                @Override
                public String getNameSpace() {
                    return this.getContextName();
                }
            }, MetricType.RESPONSETIME, false).getMetricData();
            metric.setContextName(contextName);
            ResponseTimeMetric metric1 = (ResponseTimeMetric)metricStore.getMetric(contextName, seqNameSpace, metricName1, MetricType.RESPONSETIME, false).getMetricData();
            metric1.setContextName(contextName);
            if (this.isErroneous()) {
                metric.recordErroneousData(this.duration);
                metric1.recordErroneousData(this.duration);
            } else {
                metric.recordData(this.duration);
                metric1.recordData(this.duration);
            }
        }
        catch (Exception e) {
            String error = MessageFormat.format("Exception while generating metric for query: {0} Sequence: {1}", this.operation, seqNameSpace);
            JavaAgent.logger.log(Level.WARN, error, e);
        }
        return true;
    }

    @Override
    public Map<String, Object> getMoreData(Map<String, Object> addInfo) {
        if (this.criteria.length() > 0) {
            addInfo.put("query", this.criteria);
        }
        return addInfo;
    }

    @Override
    public String getTrackerSignature() {
        StringBuilder signature = new StringBuilder();
        signature.append(this.pointcutProperties.getComponent().toString());
        signature.append(" - ");
        signature.append(this.operation.toUpperCase());
        signature.append(" - ");
        signature.append(this.fullName);
        if (this.isErroneous()) {
            signature.append(" Error: ");
            signature.append(this.error.getClass().getSimpleName());
        }
        return signature.toString();
    }
}

