/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.netty;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.WebSequenceConfig;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ApdexMetric;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.HTTPMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.WebSeqRootTracker;
import com.manageengine.apminsight.agent.trackers.http.HttpParamsObfuscator;
import com.manageengine.apminsight.agent.util.SequenceURINormalizer;
import com.manageengine.apminsight.agent.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NettyServerTracker
extends WebSeqRootTracker {
    private String queryString;
    private int httpCode;
    private Map<String, List<String>> httpHeaders;
    private Map<String, List<String>> queryParams;

    public NettyServerTracker(PointcutProperties pointcut, Object requestObj) {
        super(pointcut, null, null);
        this.getHttpInfo(requestObj);
    }

    private void getHttpInfo(Object reqObj) {
        try {
            Method m;
            Class<?> clz = reqObj.getClass();
            try {
                m = clz.getMethod("getPath", new Class[0]);
                Object requestPathObj = m.invoke(reqObj, new Object[0]);
                this.unnormalizedSeqName = requestPathObj.toString();
            }
            catch (Throwable th) {
                Method m2 = clz.getMethod("uri", new Class[0]);
                this.unnormalizedSeqName = (String)m2.invoke(reqObj, new Object[0]);
            }
            m = clz.getMethod("method", new Class[0]);
            this.httpMethod = m.invoke(reqObj, new Object[0]).toString();
            WebSequenceConfig config = ContextInfoManager.getInstance().getDefaultContextInfo().getConfig().getWebSeqConfig();
            if (config.isRecordSequenceTraceInputParams()) {
                String[] reqParts = this.unnormalizedSeqName.split("\\?");
                this.unnormalizedSeqName = reqParts[0];
                if (reqParts.length > 1) {
                    this.queryString = HttpParamsObfuscator.obfuscate(reqParts[1]);
                }
                this.recordHttpParams(reqObj);
            }
            if (config.isCaptureHttpHeadersEnabled()) {
                this.recordHeaders(reqObj, config.getExcludeHttpHeadersRegex());
            }
        }
        catch (Exception e) {
            JavaAgent.logger.warn("[NettyServer] Unable to get http info. " + e.getMessage());
        }
    }

    private void recordHttpParams(Object reqObj) {
        try {
            Class<?> clz = reqObj.getClass();
            Method m = clz.getMethod("getQueryParams", new Class[0]);
            Object multivalueMap = m.invoke(reqObj, new Object[0]);
            m = multivalueMap.getClass().getDeclaredMethod("entrySet", new Class[0]);
            Set entries = (Set)m.invoke(multivalueMap, new Object[0]);
            for (Map.Entry entry : entries) {
                String[] value = HttpParamsObfuscator.obfuscate((String)entry.getKey(), null);
                if (value == null) {
                    this.queryParams.put((String)entry.getKey(), (List<String>)entry.getValue());
                    continue;
                }
                this.queryParams.put((String)entry.getKey(), Arrays.asList(value));
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Unable to record netty http params. Exception: ", th.getMessage());
        }
    }

    private void recordHeaders(Object reqObj, String ignoreHeadersRegex) {
        try {
            Class<?> clz = reqObj.getClass();
            Method m = clz.getMethod("getHeaders", new Class[0]);
            Object headers = m.invoke(reqObj, new Object[0]);
            HashMap<String, List<String>> entries = new HashMap<String, List<String>>();
            clz = headers.getClass();
            m = clz.getDeclaredMethod("keySet", new Class[0]);
            Set keys = (Set)m.invoke(headers, new Object[0]);
            for (String key : keys) {
                if (key.matches(ignoreHeadersRegex)) continue;
                m = clz.getMethod("getValuesAsList", String.class);
                List values = (List)m.invoke(headers, key);
                entries.put(key, values);
            }
            if (entries.size() > 0) {
                this.httpHeaders = entries;
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Unable to record netty http headers. Exception: ", th.getMessage());
        }
    }

    @Override
    protected String assignSequenceName() {
        this.seqName = StringUtils.isEmptyString(this.unnormalizedSeqName) ? "unknown" : SequenceURINormalizer.normalizeURI(this.unnormalizedSeqName);
        this.hasMetric = true;
        return this.seqName;
    }

    public void setStatusCode(int code) {
        this.httpCode = code;
        if (this.httpCode >= 400) {
            this.markAsErrorTxn();
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childTrackersDuration, MetricData metricData) {
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.duration - childTrackersDuration, this.isErroneous());
        if (this.httpCode >= 400) {
            ((HTTPMetric)metricData).recordHttpRespCode(this.httpCode);
        }
        if (this.httpCode >= 400 || this.isErroneous()) {
            ((ApdexMetric)metricData).recordErroneousData(this.duration);
        } else {
            ((ApdexMetric)metricData).recordData(this.getDuration(), seqHeader.getApplicationConfig().getWebSeqConfig().getApdexThreshold());
        }
        return true;
    }

    @Override
    public Map<String, Object> getContextualMetrics() {
        LinkedHashMap<String, Object> xtraMetrics = new LinkedHashMap<String, Object>(4, 1.0f);
        if (this.httpMethod != null) {
            xtraMetrics.put("http_method_name", this.httpMethod);
        }
        if (this.queryString != null) {
            xtraMetrics.put("http_query_str", this.queryString);
        }
        if (this.queryParams != null) {
            xtraMetrics.put("http_input_params", this.queryParams);
        }
        if (this.httpHeaders != null) {
            xtraMetrics.put("http_headers", this.httpHeaders);
        }
        if (this.httpCode != 0) {
            xtraMetrics.put("httpcode", this.httpCode);
        }
        return xtraMetrics;
    }
}

