/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.quarkus.vertx;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ApdexMetric;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.HTTPMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.WebSeqRootTracker;
import com.manageengine.apminsight.agent.trackers.quarkus.vertx.VertxRequest;
import com.manageengine.apminsight.agent.trackers.quarkus.vertx.VertxResponse;
import com.manageengine.apminsight.agent.util.SequenceURINormalizer;
import com.manageengine.apminsight.agent.util.StringUtils;
import java.util.Map;

public class QuarkusVertxRootTracker
extends WebSeqRootTracker {
    private int statusCode = 0;
    private long bytesIn = -1L;
    private long bytesOut = -1L;
    private VertxResponse response;

    public QuarkusVertxRootTracker(PointcutProperties pointcutProperties, Object request, Object response) {
        super(pointcutProperties, null, null);
        this.httpReq = new VertxRequest(request);
        this.response = new VertxResponse(response);
        this.getRequestInfo();
        this.setDTResponseHeader(this.response);
    }

    private void getRequestInfo() {
        try {
            this.unnormalizedSeqName = this.httpReq.getRequestURI();
            this.unnormalizedSeqName = this.unnormalizedSeqName.split("\\?")[0];
            this.httpMethod = this.httpReq.getMethod();
            this.bytesIn = this.httpReq.getContentLength();
            this.recordHttpHeaders();
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Unable to get request info. Exception: " + th.getMessage());
        }
    }

    @Override
    protected String assignSequenceName() {
        this.seqName = StringUtils.isEmptyString(this.unnormalizedSeqName) ? "unknown" : SequenceURINormalizer.normalizeURI(this.unnormalizedSeqName);
        this.hasMetric = true;
        return this.seqName;
    }

    @Override
    protected void quit() {
        super.quit();
        try {
            this.statusCode = this.response.getResponseStatus();
            this.bytesOut = this.response.getBytesWritten();
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Unable to get response info. Exception: " + th.getMessage());
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childTrackersDuration, MetricData metricData) {
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.duration - childTrackersDuration, this.isErroneous());
        if (this.statusCode >= 400) {
            ((HTTPMetric)metricData).recordHttpRespCode(this.statusCode);
            ((ApdexMetric)metricData).recordErroneousData(this.getDuration());
        } else {
            ((ApdexMetric)metricData).recordData(this.getDuration(), seqHeader.getApplicationConfig().getWebSeqConfig().getApdexThreshold());
        }
        if (seqHeader.getApplicationConfig().getWebSeqConfig().isCaptureHttpBytesEnabled()) {
            ((HTTPMetric)metricData).recordBytesInOut(this.bytesIn, this.bytesOut);
        }
        return true;
    }

    @Override
    public Map<String, Object> getContextualMetrics() {
        Map<String, Object> data = super.getContextualMetrics();
        if (this.statusCode != 0) {
            data.put("httpcode", this.statusCode);
        }
        if (this.bytesIn != -1L) {
            data.put("hbytesin", this.bytesIn);
        }
        if (this.bytesOut != -1L) {
            data.put("hbytes", this.bytesOut);
        }
        return data;
    }
}

