/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.spring;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.background.BackgroundSeqRootTracker;
import com.manageengine.apminsight.agent.util.StringUtils;
import java.lang.reflect.Method;

public class SpringBatchTracker
extends BackgroundSeqRootTracker {
    private String jobName;
    private String stepName;

    public SpringBatchTracker(PointcutProperties pointcut, Object thisObj, Object[] args) {
        super(pointcut, thisObj, args);
        if (pointcut.getInterceptedMethodName().equals("run")) {
            try {
                Method method = args[0].getClass().getMethod("getName", new Class[0]);
                this.jobName = method.invoke(args[0], new Object[0]).toString();
            }
            catch (Exception e) {
                JavaAgent.logger.warn("[SpringBatch] Exception occured while getting jobName. " + e.getMessage());
            }
        }
        if (pointcut.getInterceptedMethodName().equals("execute") && pointcut.getInterceptedClassName().endsWith("Step")) {
            try {
                Method getNameMethod = thisObj.getClass().getMethod("getName", new Class[0]);
                getNameMethod.setAccessible(true);
                this.stepName = getNameMethod.invoke(thisObj, new Object[0]).toString();
            }
            catch (Exception e) {
                JavaAgent.logger.warn("Unable to extract getName method from " + pointcut.getInterceptedClassName() + " : " + e.getMessage());
            }
        }
    }

    @Override
    protected String assignSequenceName() {
        this.seqName = !StringUtils.isEmptyString(this.jobName) ? this.jobName + "." + this.pointcutProperties.getInterceptedMethodName() : super.assignSequenceName();
        this.hasMetric = true;
        return this.seqName;
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        super.generateMetric(seqHeader, childDuration, metricData);
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.duration - childDuration, this.isErroneous());
        return this.hasMetric;
    }

    @Override
    public String getTrackerSignature() {
        String signature = "";
        signature = !StringUtils.isEmptyString(this.stepName) ? this.stepName + '.' + this.pointcutProperties.getInterceptedMethodName() + "(" + ")" : super.getTrackerSignature();
        if (this.isErroneous()) {
            signature = signature + " Error: ";
            signature = signature + this.error.getClass().getSimpleName();
        }
        return signature;
    }
}

