/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.spring;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.sequence.SequenceType;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.netty.NettyServerTracker;
import java.lang.reflect.Method;

public class SpringServerHttpAdapterTracker
extends CallerAsyncRootTracker {
    private NettyServerTracker parentTracker;

    public SpringServerHttpAdapterTracker(PointcutProperties pointcutProperties, Object[] args, NettyServerTracker parentTracker) {
        super(pointcutProperties, null, null);
        if (parentTracker != null) {
            this.parentTracker = parentTracker;
        }
        this.setCallbackObj(args[1]);
    }

    @Override
    public SequenceType getSequenceType() {
        return SequenceType.WEB_HTTP;
    }

    @Override
    public void markCompleted(Object thisObj) {
        super.markCompleted(thisObj);
        this.getStatusCode(thisObj);
    }

    private void getStatusCode(Object thisObj) {
        try {
            Method m = thisObj.getClass().getMethod("getRawStatusCode", new Class[0]);
            m.setAccessible(true);
            int statusCode = (Integer)m.invoke(thisObj, new Object[0]);
            if (this.parentTracker != null) {
                this.parentTracker.setStatusCode(statusCode);
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[SpringServerHttpAdapter] Unable to get status code. Exception: " + th.getLocalizedMessage());
        }
    }

    @Override
    public String getTrackerSignature() {
        String sign = super.getTrackerSignature();
        return sign + this.pointcutProperties.getSignature();
    }
}

