/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.synapse;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.external.IExternalTracker;
import com.manageengine.apminsight.agent.trackers.httpclient.HttpClientTrackerUtil;
import java.lang.reflect.Method;

public class SynapsePassThruClientCallTracker
extends CallerAsyncRootTracker
implements IExternalTracker {
    private String endpoint;
    private String serverAddress;
    private int status;

    public SynapsePassThruClientCallTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
        try {
            Method m = args[1].getClass().getMethod("getAddress", new Class[0]);
            this.endpoint = (String)m.invoke(args[1], new Object[0]);
            this.setCallbackObj(args[0]);
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Unable to get synapse endpointref address, Exception: " + th.getMessage());
        }
    }

    public void setStatus(Object conn) {
        try {
            Method m = conn.getClass().getMethod("getHttpResponse", new Class[0]);
            m.setAccessible(true);
            Object response = m.invoke(conn, new Object[0]);
            m = response.getClass().getMethod("getStatusLine", new Class[0]);
            Object statusline = m.invoke(response, new Object[0]);
            m = statusline.getClass().getMethod("getStatusCode", new Class[0]);
            this.status = (Integer)m.invoke(statusline, new Object[0]);
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[SynapseClient] Unable to get status code of client call. Exception:" + th.getMessage());
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.getServerAddress(), this.duration, this.isErroneous());
        return true;
    }

    @Override
    public String getTrackerSignature() {
        if (this.endpoint == null) {
            return super.getTrackerSignature();
        }
        StringBuilder sb = new StringBuilder(this.getTrackerSignaturePrefix());
        if (this.status != 0) {
            sb.append("- ");
            sb.append(this.status);
        }
        if (this.endpoint != null) {
            sb.append(" - ");
            sb.append(this.endpoint);
        }
        return sb.toString();
    }

    @Override
    public String getServerAddress() {
        if (this.serverAddress == null) {
            this.serverAddress = HttpClientTrackerUtil.extractServerAddress(this.endpoint);
        }
        return this.serverAddress;
    }
}

