/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.util;

import com.manageengine.apminsight.agent.util.StringUtils;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HostNameUtil {
    public static final String DEFAULT_HOSTNAME = "localhost";

    public static String getLocalhostName() {
        String hostname = System.getProperty("weblogic.Name");
        if (!StringUtils.isEmptyString(hostname)) {
            return hostname;
        }
        hostname = System.getProperty("jboss.server.name");
        if (!StringUtils.isEmptyString(hostname)) {
            return hostname;
        }
        hostname = System.getProperty("apminsight.hostname");
        if (!StringUtils.isEmptyString(hostname)) {
            return hostname;
        }
        return HostNameUtil.getActualHostname();
    }

    public static String getActualHostname() {
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            if (!StringUtils.isEmptyString(hostname)) {
                return hostname;
            }
        }
        catch (UnknownHostException e) {
            try {
                for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                    ArrayList<InetAddress> addresses = Collections.list(networkInterface.getInetAddresses());
                    if (addresses.size() <= 0) continue;
                    for (InetAddress inetAddress : addresses) {
                        if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                        return inetAddress.getHostAddress();
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return DEFAULT_HOSTNAME;
    }

    public static List<String> getIPAddresses() {
        ArrayList<String> ipAddresses = new ArrayList<String>(1);
        String loopbackIp = null;
        try {
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                ArrayList<InetAddress> addresses = Collections.list(networkInterface.getInetAddresses());
                for (InetAddress address : addresses) {
                    if (!(address instanceof Inet4Address)) continue;
                    if (!address.isLoopbackAddress()) {
                        ipAddresses.add(address.getHostAddress());
                        continue;
                    }
                    loopbackIp = address.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (ipAddresses.isEmpty()) {
            ipAddresses.add(loopbackIp != null ? loopbackIp : " 127.0.0.1".trim());
        }
        return ipAddresses;
    }

    public static String getFQDN() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return DEFAULT_HOSTNAME;
        }
    }
}

