/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.util;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.util.StringUtils;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InetAddressUtil {
    public static final String HOST_IP_SPLITTER = "/";
    public static final String IP_PORT_SPLITTER = ":";
    private static final int PORT_DV = -1;
    private static Map<String, String> addressLookupTable = new ConcurrentHashMap<String, String>();

    public static String standardizeServerAddress(String address) {
        if (address == null) {
            return null;
        }
        String standardAddress = addressLookupTable.get(address);
        if (!StringUtils.isEmptyString(standardAddress)) {
            return standardAddress;
        }
        try {
            int hostIpSplitterIndex = address.indexOf(HOST_IP_SPLITTER);
            int ipPortSplitterIndex = address.indexOf(IP_PORT_SPLITTER);
            String host = ipPortSplitterIndex != -1 ? address.substring(0, ipPortSplitterIndex) : address;
            String port = ipPortSplitterIndex != -1 ? address.substring(ipPortSplitterIndex) : "";
            try {
                if (hostIpSplitterIndex <= 0) {
                    InetAddress inet = InetAddress.getByName(host.substring(hostIpSplitterIndex + 1));
                    host = inet.getHostName() + HOST_IP_SPLITTER + inet.getHostAddress();
                }
            }
            catch (Throwable th) {
                host = host + HOST_IP_SPLITTER + host;
            }
            standardAddress = host + port;
        }
        catch (Throwable th) {
            JavaAgent.logger.debug("[InetAddressUtil] Unable to standardize server address. " + address);
            standardAddress = "";
        }
        addressLookupTable.put(address, standardAddress);
        return standardAddress;
    }

    public static String getHostName(String address) {
        try {
            int index = address.indexOf(HOST_IP_SPLITTER);
            if (index == -1) {
                return null;
            }
            return address.substring(0, index);
        }
        catch (Throwable th) {
            JavaAgent.logger.debug("Unable to get hostname from server address " + address);
            return null;
        }
    }

    public static String getIPAddress(String address) {
        try {
            int index = address.indexOf(HOST_IP_SPLITTER);
            if (index == -1) {
                return null;
            }
            int portSplitterIndex = address.indexOf(IP_PORT_SPLITTER);
            return portSplitterIndex == -1 ? address.substring(index + 1) : address.substring(index + 1, portSplitterIndex);
        }
        catch (Throwable th) {
            JavaAgent.logger.debug("Unable to get IPAddress from server address " + address);
            return null;
        }
    }

    public static int getPort(String address) {
        try {
            int index = address.indexOf(IP_PORT_SPLITTER);
            if (index == -1) {
                return -1;
            }
            return Integer.parseInt(address.substring(index + 1));
        }
        catch (Throwable th) {
            JavaAgent.logger.debug("Unable to get port from server address " + address);
            return -1;
        }
    }
}

