/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.util;

import com.manageengine.apminsight.agent.service.AgentServiceConstants;
import com.manageengine.org.apache.commons.codec.binary.Base64;
import com.manageengine.org.apache.commons.codec.binary.Hex;
import java.io.File;
import java.io.FileInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SecurityUtil
implements AgentServiceConstants {
    private static final String DEFAULT_IV = "YXBtaW5z82749837";
    private static final String DEFAULT_KEY = "YzQpiN23qAv08rLG";

    public static String encryptString(String plainText, String key, String iv) throws NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (plainText == null) {
            return null;
        }
        Cipher cipher = SecurityUtil.constructCipher(1, key, iv);
        return Base64.encodeBase64String(cipher.doFinal(plainText.getBytes()));
    }

    public static String decryptString(String cipherText, String key, String iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        if (cipherText == null) {
            return null;
        }
        Cipher cipher = SecurityUtil.constructCipher(2, key, iv);
        return new String(cipher.doFinal(Base64.decodeBase64(cipherText)));
    }

    private static Cipher constructCipher(int mode, String key, String iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException {
        key = key == null ? DEFAULT_KEY : key;
        iv = iv == null ? DEFAULT_IV : iv;
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), "AES");
        IvParameterSpec iv_spec = new IvParameterSpec(iv.getBytes());
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(mode, (Key)secretKey, iv_spec);
        return cipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifySHA256Checksum(File file, String hash) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (FileInputStream is = new FileInputStream(file);){
            int length;
            byte[] bytes = new byte[4096];
            while ((length = is.read(bytes)) > 0) {
                digest.update(bytes, 0, length);
            }
        }
        String fileHash = new String(new Hex().encode(digest.digest()));
        return fileHash.equals(hash);
    }
}

