/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.util;

import com.manageengine.apminsight.agent.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SequenceURINormalizer {
    private static int options = 10;
    private static Pattern uriPattern = Pattern.compile("([\\/\\w\\-\\.]+[^#?;\\s]+)((#|\\?|;)?(.*))?", options);
    private static Pattern staticResourcePattern = Pattern.compile("(.*/)?(.*).(css|js|tiff|gif|png|ico|bmp|jpg|jpeg|webp|svg|svgz)$", options);
    private static Pattern endResourcePattern = Pattern.compile("(/)[^/]*$", options);
    private static final String TIDY_URI_MATCHER_REGEX = "[^/]*[0-9][^/]*";
    private static Pattern tidyUriMatcherPattern = Pattern.compile("[^/]*[0-9][^/]*", options);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(boolean normalizeRoutedURIs) {
        Pattern pattern = tidyUriMatcherPattern;
        synchronized (pattern) {
            tidyUriMatcherPattern = !normalizeRoutedURIs ? Pattern.compile("^\\?") : Pattern.compile(TIDY_URI_MATCHER_REGEX, options);
        }
    }

    public static String normalizeURI(String uri) {
        Matcher staticResourceMatcher;
        if ("/".equals(uri)) {
            return uri;
        }
        if ((uri = SequenceURINormalizer.getURIPath(uri)).startsWith("/")) {
            uri = uri.substring(uri.indexOf(47) + 1);
        }
        if ((staticResourceMatcher = staticResourcePattern.matcher(uri)).matches()) {
            StringBuilder sb = new StringBuilder();
            sb.append(StringUtils.trim(staticResourceMatcher.group(1))).append("*.").append(staticResourceMatcher.group(3));
            uri = sb.toString();
        }
        Matcher tidyMatcher = tidyUriMatcherPattern.matcher(uri);
        uri = tidyMatcher.replaceAll("*");
        return uri;
    }

    public static String getURIPath(String uri) {
        Matcher uriMatcher = uriPattern.matcher(uri);
        return uriMatcher.matches() ? uriMatcher.group(1) : uri;
    }
}

