/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.util;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.AbstractTracker;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.IteratorTracker;
import com.manageengine.apminsight.agent.trackers.LoopTracker;
import com.manageengine.apminsight.agent.trackers.MethodTracker;
import com.manageengine.apminsight.agent.trackers.db.DatabaseTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TraceTree {
    private final LoopTracker parentLoop;
    private IteratorTracker lastTracker = null;
    public IteratorTracker firstTracker = null;
    private DefaultTracker placeHolder = null;
    private boolean externalCallCaptured;
    private final Map<String, List<IteratorTracker>> aggregateTracker = new HashMap<String, List<IteratorTracker>>();
    private final Map<PointcutProperties, IteratorTracker> iteratorTrackersByPointcut = new HashMap<PointcutProperties, IteratorTracker>();

    public TraceTree(LoopTracker loopTracker) {
        this.parentLoop = loopTracker;
    }

    public DefaultTracker transformTracker(DefaultTracker t) {
        if (SequenceSpace.SEQUENCE_BOOK.get().getIteratorTrackerCount() > 1000) {
            return null;
        }
        if (!t.isMetricHolded() && (t.isLeafTracker() || t instanceof DatabaseTracker)) {
            if (this.placeHolder == null || this.placeHolder instanceof DatabaseTracker) {
                this.placeHolder = t;
            }
            return t;
        }
        IteratorTracker iterTracker = this.getIteratorTracker(t);
        iterTracker.start(t);
        this.lastTracker = iterTracker;
        return iterTracker;
    }

    private void attachTracker(IteratorTracker t) {
        if (this.lastTracker == null) {
            this.lastTracker = this.firstTracker = t;
            this.firstTracker.nominee = this.parentLoop;
        } else {
            if (this.lastTracker.isClosed) {
                IteratorTracker temp = (IteratorTracker)this.lastTracker.sibling;
                if (temp != null) {
                    t.sibling = temp;
                    temp.nominee = t;
                }
                this.lastTracker.sibling = t;
                t.nominee = this.lastTracker;
                if (this.lastTracker.parent != null) {
                    t.parent = this.lastTracker.parent;
                }
            } else {
                if (this.lastTracker.child == null) {
                    this.lastTracker.child = t;
                } else {
                    IteratorTracker temp = (IteratorTracker)this.lastTracker.child;
                    this.lastTracker.child = t;
                    t.sibling = temp;
                    temp.nominee = t;
                }
                t.parent = this.lastTracker;
                t.nominee = this.lastTracker;
            }
            this.lastTracker = t;
        }
    }

    public void cleanAndUpdate(AbstractTracker t) {
        if (SequenceSpace.SEQUENCE_BOOK.get().getIteratorTrackerCount() > 1000) {
            return;
        }
        try {
            if (this.placeHolder != null) {
                if (t != this.placeHolder) {
                    return;
                }
                this.placeHolder = null;
            } else if (t instanceof DatabaseTracker) {
                return;
            }
            IteratorTracker iterTracker = this.getIteratorTracker(t);
            if (t.iteratorTracker == null) {
                iterTracker.start(t);
            }
            iterTracker.quit();
            this.lastTracker = iterTracker;
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Error in TraceTree.cleanAndUpdate", th);
        }
    }

    public void dropTrackerFinal(IteratorTracker t) {
        try {
            if (t.nominee != null) {
                AbstractTracker extClosed;
                AbstractTracker temp;
                if (t.nominee.child == t) {
                    if (t.child == null) {
                        t.nominee.child = t.sibling;
                    } else {
                        t.nominee.child = t.child;
                        temp = t.child;
                        extClosed = null;
                        while (temp != null) {
                            extClosed = temp;
                            temp = temp.sibling;
                        }
                        temp = null;
                        extClosed.sibling = t.sibling;
                        if (t.sibling instanceof IteratorTracker) {
                            ((IteratorTracker)t.sibling).nominee = extClosed;
                        }
                    }
                    if (t.nominee.child instanceof IteratorTracker) {
                        ((IteratorTracker)t.nominee.child).nominee = t.nominee;
                    }
                }
                if (t.nominee.sibling == t) {
                    if (t.child == null) {
                        t.nominee.sibling = t.sibling;
                    } else {
                        t.nominee.sibling = t.child;
                        temp = t.child;
                        extClosed = null;
                        while (temp != null) {
                            extClosed = temp;
                            temp = temp.sibling;
                        }
                        temp = null;
                        extClosed.sibling = t.sibling;
                        if (t.sibling instanceof IteratorTracker) {
                            ((IteratorTracker)t.sibling).nominee = extClosed;
                        }
                    }
                    if (t.nominee.sibling instanceof IteratorTracker) {
                        ((IteratorTracker)t.nominee.sibling).nominee = t.nominee;
                    }
                }
            } else if (this.firstTracker != t) {
                JavaAgent.logger.warn("error tracker nominee is null");
            } else {
                if (t.child instanceof IteratorTracker) {
                    this.firstTracker = (IteratorTracker)t.child;
                } else if (t.sibling instanceof IteratorTracker) {
                    this.firstTracker = (IteratorTracker)t.sibling;
                } else if (t.child == null && t.sibling == null) {
                    this.firstTracker = null;
                } else {
                    JavaAgent.logger.warn("error firsttracker");
                }
                this.parentLoop.child = this.firstTracker;
            }
        }
        catch (Exception e) {
            JavaAgent.logger.warn("error dropTrackerFinal", e);
        }
    }

    private IteratorTracker getIteratorTracker(AbstractTracker t) {
        IteratorTracker iteratorTracker = t.iteratorTracker;
        if (iteratorTracker == null) {
            boolean isNew = false;
            String signature = null;
            if (t instanceof MethodTracker || t instanceof LoopTracker) {
                PointcutProperties pointcut = t.getPointcutProperties();
                iteratorTracker = this.iteratorTrackersByPointcut.get(pointcut);
            } else {
                signature = t.getNormalizedSignature();
                List<IteratorTracker> iterList = this.aggregateTracker.get(signature);
                if (iterList != null) {
                    for (IteratorTracker prevTracker : iterList) {
                        if (!this.isTrackerFlowSameAsCurrentFlow(prevTracker)) continue;
                        iteratorTracker = prevTracker;
                        break;
                    }
                    if (iteratorTracker == null) {
                        iteratorTracker = new IteratorTracker(signature, t.getPointcutProperties());
                        iterList.add(iteratorTracker);
                        isNew = true;
                    }
                }
            }
            if (isNew || iteratorTracker == null) {
                if (iteratorTracker == null) {
                    iteratorTracker = new IteratorTracker(signature, t.getPointcutProperties());
                    if (t instanceof MethodTracker || t instanceof LoopTracker) {
                        this.iteratorTrackersByPointcut.put(t.getPointcutProperties(), iteratorTracker);
                    } else {
                        ArrayList<IteratorTracker> l = new ArrayList<IteratorTracker>();
                        l.add(iteratorTracker);
                        this.aggregateTracker.put(signature, l);
                    }
                }
                this.attachTracker(iteratorTracker);
                if (t.isExternalTracker()) {
                    this.externalCallCaptured = true;
                }
                int index = t instanceof DatabaseTracker ? 2 : (t.isExternalTracker() ? 1 : 0);
                SequenceSpace.SEQUENCE_BOOK.get().incrementIteratorTrackerCount(index);
            }
        }
        return iteratorTracker;
    }

    private boolean isTrackerFlowSameAsCurrentFlow(IteratorTracker p2) {
        IteratorTracker p1 = this.lastTracker.isClosed ? this.lastTracker.parent : this.lastTracker;
        p2 = p2.parent;
        while (p2 != null) {
            if (p1 != p2) {
                return false;
            }
            p1 = p1.parent;
            p2 = p2.parent;
        }
        return p1 == p2;
    }

    public boolean isExternalCallCaptured() {
        return this.externalCallCaptured;
    }
}

