/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.vm;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;

public class GCInfoCapture {
    public static final int TIME = 1;
    public static final int COUNT = 2;
    private static List<GarbageCollectorMXBean> gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
    protected int metricOption = 3;
    protected long elapsedTime = 0L;
    protected long totalGCTime = 0L;
    protected long totalGCCount = 0L;
    private static ThreadLocal<GCInfoCapture> gcInfoLocal = new ThreadLocal();

    protected GCInfoCapture() {
    }

    protected GCInfoCapture(int options) {
        for (GarbageCollectorMXBean gcMXBean : gcMXBeans) {
            if ((this.metricOption & 1) == 1) {
                this.totalGCTime += gcMXBean.getCollectionTime();
            }
            if ((this.metricOption & 2) != 2) continue;
            this.totalGCCount += gcMXBean.getCollectionCount();
        }
    }

    public static void start() {
        GCInfoCapture.start(3);
    }

    public static void start(int options) {
        gcInfoLocal.set(new GCInfoCapture(options));
    }

    public static GCInfoCapture end() {
        GCInfoCapture snapshot = gcInfoLocal.get();
        if (snapshot == null) {
            return null;
        }
        int metricOption = snapshot.metricOption;
        GCInfoCapture gcc = new GCInfoCapture(metricOption);
        gcc.elapsedTime = System.currentTimeMillis() - snapshot.elapsedTime;
        int totalGCTime = 0;
        int totalGCCount = 0;
        for (GarbageCollectorMXBean gcMXBean : gcMXBeans) {
            if ((metricOption & 1) == 1) {
                totalGCTime = (int)((long)totalGCTime + gcMXBean.getCollectionTime());
            }
            if ((metricOption & 2) != 2) continue;
            totalGCCount = (int)((long)totalGCCount + gcMXBean.getCollectionCount());
        }
        if ((metricOption & 1) == 1) {
            gcc.totalGCTime = (long)totalGCTime - snapshot.totalGCTime;
        }
        if ((metricOption & 2) == 2) {
            gcc.totalGCCount = (long)totalGCCount - snapshot.totalGCCount;
        }
        return gcc;
    }

    public void traceMetric(String nameSpace) {
    }

    public String getMetricName() {
        StringBuilder sb = new StringBuilder("GCInfo");
        return sb.toString();
    }
}

