/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.org.bouncycastle.crypto.agreement;

import com.manageengine.org.bouncycastle.crypto.BasicAgreement;
import com.manageengine.org.bouncycastle.crypto.CipherParameters;
import com.manageengine.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.manageengine.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.manageengine.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public class ECDHBasicAgreement
implements BasicAgreement {
    private ECPrivateKeyParameters key;

    public void init(CipherParameters cipherParameters) {
        this.key = (ECPrivateKeyParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)cipherParameters;
        ECPoint eCPoint = eCPublicKeyParameters.getQ().multiply(this.key.getD()).normalize();
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDH");
        }
        return eCPoint.getAffineXCoord().toBigInteger();
    }
}

