/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.org.bouncycastle.crypto.generators;

import com.manageengine.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.manageengine.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.manageengine.org.bouncycastle.crypto.KeyGenerationParameters;
import com.manageengine.org.bouncycastle.crypto.params.ECDomainParameters;
import com.manageengine.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.manageengine.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.manageengine.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.manageengine.org.bouncycastle.math.ec.ECConstants;
import com.manageengine.org.bouncycastle.math.ec.ECMultiplier;
import com.manageengine.org.bouncycastle.math.ec.ECPoint;
import com.manageengine.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.manageengine.org.bouncycastle.math.ec.WNafUtil;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
        if (this.random == null) {
            this.random = new SecureRandom();
        }
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        int n2 = n >>> 2;
        while ((bigInteger = new BigInteger(n, this.random)).compareTo(TWO) < 0 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n2) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

