/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.org.bouncycastle.jcajce.provider.symmetric;

import com.manageengine.org.bouncycastle.crypto.CipherKeyGenerator;
import com.manageengine.org.bouncycastle.crypto.engines.VMPCEngine;
import com.manageengine.org.bouncycastle.crypto.macs.VMPCMac;
import com.manageengine.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.manageengine.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.manageengine.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.manageengine.org.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import com.manageengine.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class VMPC {
    private VMPC() {
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new VMPCEngine(), 16);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("VMPC", 128, new CipherKeyGenerator());
        }
    }

    public static class Mac
    extends BaseMac {
        public Mac() {
            super(new VMPCMac());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = VMPC.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.VMPC", PREFIX + "$Base");
            configurableProvider.addAlgorithm("KeyGenerator.VMPC", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("Mac.VMPCMAC", PREFIX + "$Mac");
            configurableProvider.addAlgorithm("Alg.Alias.Mac.VMPC", "VMPCMAC");
            configurableProvider.addAlgorithm("Alg.Alias.Mac.VMPC-MAC", "VMPCMAC");
        }
    }
}

