/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.org.bouncycastle.math.ec.custom.sec;

import com.manageengine.org.bouncycastle.math.ec.ECConstants;
import com.manageengine.org.bouncycastle.math.ec.ECCurve;
import com.manageengine.org.bouncycastle.math.ec.ECFieldElement;
import com.manageengine.org.bouncycastle.math.ec.ECPoint;
import com.manageengine.org.bouncycastle.math.ec.custom.sec.SecT571FieldElement;
import com.manageengine.org.bouncycastle.math.ec.custom.sec.SecT571R1Point;
import com.manageengine.org.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.util.Random;

public class SecT571R1Curve
extends ECCurve.AbstractF2m {
    private static final int SecT571R1_DEFAULT_COORDS = 6;
    protected SecT571R1Point infinity = new SecT571R1Point(this, null, null);
    static final SecT571FieldElement SecT571R1_B = new SecT571FieldElement(new BigInteger(1, Hex.decode("02F40E7E2221F295DE297117B7F3D62F5C6A97FFCB8CEFF1CD6BA8CE4A9A18AD84FFABBD8EFA59332BE7AD6756A66E294AFD185A78FF12AA520E4DE739BACA0C7FFEFF7F2955727A")));
    static final SecT571FieldElement SecT571R1_B_SQRT = (SecT571FieldElement)SecT571R1_B.sqrt();

    public SecT571R1Curve() {
        super(571, 2, 5, 10);
        this.a = this.fromBigInteger(BigInteger.valueOf(1L));
        this.b = SecT571R1_B;
        this.order = new BigInteger(1, Hex.decode("03FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE661CE18FF55987308059B186823851EC7DD9CA1161DE93D5174D66E8382E9BB2FE84E47"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT571R1Curve();
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int getFieldSize() {
        return 571;
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT571FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
        return new SecT571R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl) {
        return new SecT571R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return false;
    }

    protected ECPoint decompressPoint(int n, BigInteger bigInteger) {
        ECFieldElement eCFieldElement = this.fromBigInteger(bigInteger);
        ECFieldElement eCFieldElement2 = null;
        if (eCFieldElement.isZero()) {
            eCFieldElement2 = SecT571R1_B_SQRT;
        } else {
            ECFieldElement eCFieldElement3 = eCFieldElement.square().invert().multiply(this.b).add(this.a).add(eCFieldElement);
            ECFieldElement eCFieldElement4 = this.solveQuadraticEquation(eCFieldElement3);
            if (eCFieldElement4 != null) {
                if (eCFieldElement4.testBitZero() != (n == 1)) {
                    eCFieldElement4 = eCFieldElement4.addOne();
                }
                switch (this.getCoordinateSystem()) {
                    case 5: 
                    case 6: {
                        eCFieldElement2 = eCFieldElement4.add(eCFieldElement);
                        break;
                    }
                    default: {
                        eCFieldElement2 = eCFieldElement4.multiply(eCFieldElement);
                    }
                }
            }
        }
        if (eCFieldElement2 == null) {
            throw new IllegalArgumentException("Invalid point compression");
        }
        return this.createRawPoint(eCFieldElement, eCFieldElement2, true);
    }

    private ECFieldElement solveQuadraticEquation(ECFieldElement eCFieldElement) {
        if (eCFieldElement.isZero()) {
            return eCFieldElement;
        }
        ECFieldElement eCFieldElement2 = this.fromBigInteger(ECConstants.ZERO);
        ECFieldElement eCFieldElement3 = null;
        ECFieldElement eCFieldElement4 = null;
        Random random = new Random();
        do {
            ECFieldElement eCFieldElement5 = this.fromBigInteger(new BigInteger(571, random));
            eCFieldElement3 = eCFieldElement2;
            ECFieldElement eCFieldElement6 = eCFieldElement;
            for (int i = 1; i < 571; ++i) {
                ECFieldElement eCFieldElement7 = eCFieldElement6.square();
                eCFieldElement3 = eCFieldElement3.square().add(eCFieldElement7.multiply(eCFieldElement5));
                eCFieldElement6 = eCFieldElement7.add(eCFieldElement);
            }
            if (eCFieldElement6.isZero()) continue;
            return null;
        } while ((eCFieldElement4 = eCFieldElement3.square().add(eCFieldElement3)).isZero());
        return eCFieldElement3;
    }

    public int getM() {
        return 571;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 5;
    }

    public int getK3() {
        return 10;
    }
}

