from pathlib import Path
from setuptools import setup, find_packages
from setuptools.command.build_ext import build_ext

from apminsight import version

HERE = Path(__file__).resolve().parent

with open("README.md", "r") as fh:
    long_description = fh.read()

setup_kwargs = {
    "name": "apminsight",
    "version": version,
    "description": "Site24x7 application performance monitoring",
    "url": "https://site24x7.com",
    "author": "Zoho Corporation Pvt. Ltd.",
    "author_email": "apm-insight@zohocorp.com",
    "maintainer": "ManageEngine Site24x7",
    "maintainer_email": "apm-insight@zohocorp.com",
    "long_description": long_description,
    "long_description_content_type": "text/markdown",
    "license": "LICENSE.txt",
    "include_package_data": True,
    "python_requires": ">=3.7",
    "entry_points": {
        "console_scripts": [
            "apminsight-run = apminsight.commands.apm_run:main",
        ],
    },
    "zip_safe": False,
    "install_requires": ["psutil"],
    "packages": find_packages(exclude=["tests", "tests.*", "apminsight.dependency", "apminsight.dependency.*"]),
}

setup(**setup_kwargs)
